
package net.kldp.logviewer.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import net.kldp.logviewer.db.common.pool.ConnectionResource;

/**
 * <PRE>
 * 
 
 --  
  connect 'jdbc:derby:LogViewerDB';
  
  -- ׷ ̺
  drop table log_group;
  
  create table log_group (
    seq 		decimal(7,0) not null,
  	group_name 	varchar(100) not null,
  	group_detail varchar(2000) not null,
  	status_yn 	varchar(2) default '00' --00: 01:
  );
  
  insert into log_group values(1, 'default', '', '00');
  
  insert into log_group values(2, 'Test', '', '00');
  
  -- ʱ ̺  
  drop table log_detail;
  
  create table log_detail (
  	group_seq 	decimal(7,0) not null,
  	seq 		decimal(7,0) not null,  	 
  	name 		varchar(100) not null, 
  	type 		varchar(2) not null, -- 00: 01: ftp
  	ftpIP 		varchar(20),
  	ftpPort 	varchar(4),
  	ftpID 		varchar(20),
  	ftpPass 	varchar(20),
  	ftpMode 	varchar(2),
  	path 		varchar(100) not null, 
  	delay_second decimal(7,0),
	font 		varchar(20),
	font_size 	varchar(2),
	font_color 	varchar(20),
	background_color varchar(20),
  	status_yn 	varchar(2) default '00', --00: 01:
  	cur_back_color varchar(20),
  	line_count  varchar(3) default '5000',
  	alalrm_data	varchar(100),
  	alalrm_back_color varchar(20),
  	alarm_type varchar(2) default '00',
  	unique (group_seq, seq)
  );

//-- α ˶
//  create table log_alarm {
//  	seq				decimal(7, 0) not null,
//  	log_detail_seq 	decimal(7, 0) not null,
//  	alalrm_data		varchar(100) not null,
//  	type			varchar(2) not null,
//  	line_color		varchar(20),
//  	alert_yn		varchar(2) default '00',
//  	status_yn		varchar(2) default '00',
//    unique(seq, log_detail_seq)
//  }

  
  create table log_alarm_data (
  	seq				decimal(7, 0) not null,
  	data_seq		decimal(7, 0) not null,
  	date			date,
  	data			varchar(32672),
  	status_yn		varchar(2) default '00',
    unique(seq, data_seq)
  )
  
 *
 * History :
 * 
 * </PRE>
 * 
 * @version 0.1, 2005. 9. 15.
 * @author henry
 */
public class LogViewerDB extends ConnectionResource {
	/**
	 * Logger for this class
	 */
//	private static final Logger logger = Logger.getLogger(DBPoolTest.class);
	private static String poolname	 = "LogDB";

	/** singleton object */
	private static LogViewerDB tolosPool = new LogViewerDB();

	private LogViewerDB() {}

	/**
	 * Connection pooling Object ´.
	 * 
	 * @param transaction AutoCommint true Ѵ.
	 * @return
	 */
	public static LogViewerDB getInstanceAutoCommit() {
		tolosPool.setPoolName(poolname);
		
		try {
			tolosPool.init(true);
		} catch(Exception e) {
			e.printStackTrace();
		}
		
		return tolosPool;
	}

	/**
	 * Tolos Oracle ü Connection pooling Object ´.
	 * 
	 * @param transaction AutoCommint false Ѵ.
	 * @return
	 */
	public static LogViewerDB getInstance() {
		tolosPool.setPoolName(poolname);
		
		try {
			tolosPool.init(false);
		} catch(Exception e) {
			e.printStackTrace();
		}
		
		return tolosPool;
	}
	
	
	public static void main(String[] args) {
		String dualSelect = "SELECT * FROM log_group";
		Connection conn = null;
	    Statement stmt = null;
	    ResultSet rset = null;
	
	    try {
	        System.out.println("Creating connection.");
	        conn = LogViewerDB.getInstance().getConnection();
	        System.out.println("Creating statement.");
	        stmt = conn.createStatement();
	        System.out.println("Executing statement.");
	        rset = stmt.executeQuery(dualSelect);
	        System.out.println("Results:");
	        int numcols = rset.getMetaData().getColumnCount();	        
	        
	        while(rset.next()) {
	        	
	            for(int i=1;i<=numcols;i++) {
	            	System.out.println(rset.getMetaData().getColumnName(i) + ":" +rset.getString(i));
	            }
	        }
	        
	    } catch(SQLException e) {
	        e.printStackTrace();
	    } finally {
	        try { rset.close(); } catch(Exception e) { }
	        try { stmt.close(); } catch(Exception e) { }
	        try { conn.close(); } catch(Exception e) { }
	    }
	}
}

